/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.utils.CardContainerListener;
import dev.lucaargolo.charta.utils.CardContainerSynchronizer;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_2371;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_5916;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCardMenu<G extends CardGame<G>>
extends class_1703 {
    protected final G game;
    public final class_2371<CardSlot<G>> cardSlots = class_2371.method_10211();
    private final class_2371<GameSlot> lastCardSlots = class_2371.method_10211();
    private final class_2371<GameSlot> remoteCardSlots = class_2371.method_10211();
    private GameSlot carriedCards = new GameSlot();
    private GameSlot remoteCarriedCards = new GameSlot();
    protected final class_1661 inventory;
    protected final class_3914 access;
    protected final CardDeck deck;
    protected final class_1657 player;
    protected final CardPlayer cardPlayer;
    private int currentPlayer = 0;
    private int gameReady = 0;
    private final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            Object game = AbstractCardMenu.this.getGame();
            return switch (index) {
                case 0 -> {
                    if (((CardGame)game).getCurrentPlayer() == AbstractCardMenu.this.cardPlayer) {
                        yield 1;
                    }
                    yield AbstractCardMenu.this.currentPlayer;
                }
                case 1 -> ((CardGame)game).getPlayers().indexOf(((CardGame)game).getCurrentPlayer());
                case 2 -> {
                    if (((CardGame)game).isGameReady()) {
                        yield 1;
                    }
                    yield AbstractCardMenu.this.gameReady;
                }
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        public void method_17391(int index, int value) {
            Object game = AbstractCardMenu.this.getGame();
            switch (index) {
                case 0: {
                    AbstractCardMenu.this.currentPlayer = value;
                    break;
                }
                case 1: {
                    ((CardGame)game).setCurrentPlayer(value);
                    break;
                }
                case 2: {
                    AbstractCardMenu.this.gameReady = value;
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public AbstractCardMenu(class_3917<?> menuType, int containerId, class_1661 inventory, class_3914 access, CardDeck deck, int[] players, byte[] options) {
        super(menuType, containerId);
        this.game = CardGames.getGameForMenu(this.getGameFactory(), access, deck, players, options);
        this.inventory = inventory;
        this.player = inventory.field_7546;
        this.access = access;
        this.deck = deck;
        this.cardPlayer = ((LivingEntityMixed)this.player).charta_getCardPlayer();
        this.method_17360(this.data);
    }

    public void addTopPreview(int[] players) {
        float totalWidth = CardSlot.getWidth(CardSlot.Type.PREVIEW) + 28.0f;
        float playersWidth = (float)players.length * totalWidth + ((float)players.length - 1.0f) * (totalWidth / 10.0f);
        for (int i = 0; i < players.length; ++i) {
            G game = this.getGame();
            CardPlayer p = ((CardGame)game).getPlayers().get(i);
            this.addCardSlot(new CardSlot<CardGame>((CardGame)game, g -> g.getCensoredHand(this.cardPlayer, p), 26.0f + (70.0f - playersWidth / 2.0f) + (float)i * (totalWidth + totalWidth / 10.0f), 7.0f, CardSlot.Type.PREVIEW));
        }
    }

    public CardPlayer getCardPlayer() {
        return this.cardPlayer;
    }

    public boolean isCurrentPlayer() {
        return this.data.method_17390(0) == 1;
    }

    public CardPlayer getCurrentPlayer() {
        return ((CardGame)this.getGame()).getPlayers().get(this.data.method_17390(1));
    }

    public boolean isGameReady() {
        return this.data.method_17390(2) == 1;
    }

    public CardDeck getDeck() {
        return this.deck;
    }

    public abstract CardGames.Factory<G> getGameFactory();

    public G getGame() {
        return this.game;
    }

    public GameSlot getCarriedCards() {
        return this.carriedCards;
    }

    public GameSlot getRemoteCarriedCards() {
        return this.remoteCarriedCards;
    }

    public void setCarriedCards(GameSlot cards) {
        this.carriedCards = cards;
    }

    public void setCarriedCards(int stateId, GameSlot cards) {
        this.carriedCards = cards;
        this.field_34024 = stateId;
    }

    public void setCards(int slotId, int stateId, List<Card> cards) {
        ((CardSlot)this.cardSlots.get(slotId)).setCards(cards);
        this.field_34024 = stateId;
    }

    public GameSlot getRemoteCards(int slotId) {
        return (GameSlot)this.remoteCardSlots.get(slotId);
    }

    protected <C extends CardSlot<G>> void addCardSlot(C slot) {
        slot.index = this.cardSlots.size();
        this.cardSlots.add(slot);
        this.lastCardSlots.add((Object)new GameSlot());
        this.remoteCardSlots.add((Object)new GameSlot());
    }

    public CardSlot<G> getCardSlot(int slotId) {
        return (CardSlot)this.cardSlots.get(slotId);
    }

    private void synchronizeCardSlotToRemote(int slotIndex, GameSlot cards, java.util.function.Supplier<GameSlot> supplier) {
        GameSlot remoteCards;
        if (!this.field_29209 && !(remoteCards = (GameSlot)this.remoteCardSlots.get(slotIndex)).equals(cards)) {
            GameSlot suppliedCards = supplier.get();
            this.remoteCardSlots.set(slotIndex, (Object)suppliedCards);
            class_5916 class_59162 = this.field_29208;
            if (class_59162 instanceof CardContainerSynchronizer) {
                CardContainerSynchronizer cardContainerSynchronizer = (CardContainerSynchronizer)class_59162;
                cardContainerSynchronizer.sendCardSlotChange(this, slotIndex, suppliedCards);
            }
        }
    }

    private void synchronizeCarriedCardsToRemote() {
        if (!this.field_29209 && !this.remoteCarriedCards.equals(this.carriedCards)) {
            this.remoteCarriedCards = GameSlot.copyOf(this.carriedCards);
            class_5916 class_59162 = this.field_29208;
            if (class_59162 instanceof CardContainerSynchronizer) {
                CardContainerSynchronizer cardContainerSynchronizer = (CardContainerSynchronizer)class_59162;
                cardContainerSynchronizer.sendCarriedCardsChange(this, this.remoteCarriedCards);
            }
        }
    }

    public void method_7623() {
        for (int i = 0; i < this.cardSlots.size(); ++i) {
            GameSlot cards = ((CardSlot)this.cardSlots.get(i)).getSlot();
            Supplier cardsSupplier = Suppliers.memoize(() -> GameSlot.copyOf(cards));
            this.triggerCardSlotListeners(i, cards, (java.util.function.Supplier<GameSlot>)cardsSupplier);
            this.synchronizeCardSlotToRemote(i, cards, (java.util.function.Supplier<GameSlot>)cardsSupplier);
        }
        this.synchronizeCarriedCardsToRemote();
        super.method_7623();
    }

    public void method_37420() {
        for (int i = 0; i < this.cardSlots.size(); ++i) {
            GameSlot cards = ((CardSlot)this.cardSlots.get(i)).getSlot();
            this.triggerCardSlotListeners(i, cards, () -> GameSlot.copyOf(cards));
        }
        super.method_37420();
    }

    private void triggerCardSlotListeners(int slotIndex, GameSlot cards, java.util.function.Supplier<GameSlot> supplier) {
        GameSlot lastCards = (GameSlot)this.lastCardSlots.get(slotIndex);
        if (!lastCards.equals(cards)) {
            GameSlot suppliedCards = supplier.get();
            this.lastCardSlots.set(slotIndex, (Object)suppliedCards);
            for (class_1712 containerlistener : this.field_7765) {
                if (!(containerlistener instanceof CardContainerListener)) continue;
                CardContainerListener cardContainerListener = (CardContainerListener)containerlistener;
                cardContainerListener.cardChanged(this, slotIndex, suppliedCards);
            }
        }
    }

    public void method_34252() {
        int j = this.cardSlots.size();
        for (int i = 0; i < j; ++i) {
            this.remoteCardSlots.set(i, (Object)GameSlot.copyOf(((CardSlot)this.cardSlots.get(i)).getSlot()));
        }
        this.remoteCarriedCards = GameSlot.copyOf(this.carriedCards);
        super.method_34252();
    }

    public void method_34247(@NotNull class_1703 menu) {
        super.method_34247(menu);
        if (menu instanceof AbstractCardMenu) {
            AbstractCardMenu cardMenu = (AbstractCardMenu)menu;
            for (int j = 0; j < this.cardSlots.size(); ++j) {
                this.lastCardSlots.set(j, (Object)((GameSlot)cardMenu.lastCardSlots.get(j)));
                this.remoteCardSlots.set(j, (Object)((GameSlot)cardMenu.remoteCardSlots.get(j)));
            }
        }
    }

    public void method_7595(@NotNull class_1657 player) {
        super.method_7595(player);
        GameSlot carriedCards = this.getCarriedCards();
        if (!carriedCards.isEmpty()) {
            for (Card carriedCard : carriedCards.getCards()) {
                ((CardGame)this.getGame()).getPlayerHand(this.cardPlayer).add(carriedCard);
                ((CardGame)this.getGame()).getCensoredHand(this.cardPlayer).add(Card.BLANK);
            }
            this.setCarriedCards(new GameSlot());
        }
    }
}

